unit InfoForm;

//     , 
//          ,
//    .     
//     TypeInfo.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ExtCtrls, Buttons, Grids, Menus, TypInfo, ActnList, Mask,
  CheckLst, ValEdit, TeeProcs, TeEngine, Chart, ImgList, ComCtrls, ToolWin,
  MPlayer, OleCtnrs;

type
  TForm1 = class(TForm)
    ListParent: TListBox;
    Label1: TLabel;
    Label3: TLabel;
    Panel1: TPanel;
    ListClasses: TListBox;
    Panel2: TPanel;
    Label2: TLabel;
    EditInfo: TEdit;
    StringGrid1: TStringGrid;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ListClassesClick(Sender: TObject);
  private
  public
  end;

  procedure EnumClassProrerty(RqClass : TClass; Report : TStringGrid);

var
  Form1: TForm1;

implementation
{$R *.DFM}

//      
const ArrClass : array [0..53] of
 TClass = (
     //  
     TMainMenu, TPopupMenu, TLabel, TEdit, TMemo, TButton,
     TCheckBox, TRadioButton, TListBox, TComboBox, TScrollBar,
     TGroupBox, TRadioGroup, TPanel, TActionList,
     //  
     TBitBtn, TSpeedButton, TMaskEdit, TStringGrid, TDrawGrid,
     TImage, TShape, TBevel, TScrollBox, TCheckListBox, TSplitter,
     TStaticText, TControlBar, TValueListEditor, TLabeledEdit,
     TColorBox, TChart, {31}
     // Win32 
     TPageControl, TImageList, TRichEdit, TTrackBar, TProgressBar,
     TUpDown, THotKey, TAnimate, TDateTimePicker, TMonthCalendar,
     TTreeView, TListView, THeaderControl, TStatusBar, TToolBar,
     TCoolBar, TPageScroller, TComboBoxEx,
     // System 
     TTimer, TPaintBox, TMediaPlayer, TOleContainer {Ind = 53}
           );

//  - 
procedure TForm1.FormCreate(Sender: TObject);
var Ind : Integer;
begin
  //     ListBox
  for Ind := Low(ArrClass) to High(ArrClass) do
    ListClasses.Items.Add(ArrClass[Ind].ClassName);
    //    
    ListClasses.ItemIndex := 0;
    //       
    ListClassesClick (Sender);
end;

//    ( ) 
//     
procedure TForm1.ListClassesClick(Sender: TObject);
var MyClass: TClass;
begin
  MyClass := ArrClass[ListClasses.ItemIndex];
  EditInfo.Text := Format (' %s     Size: %d bytes',
    [MyClass.ClassName, MyClass.InstanceSize]);
  EnumClassProrerty(MyClass, StringGrid1);
  with ListParent.Items do
  begin
    Clear;
    while MyClass.ClassParent <> nil do
    begin
      MyClass := MyClass.ClassParent;
      Add (MyClass.ClassName);
    end;
  end;

end;
//       
procedure ShowClassProrerty (PListProp : PPropList;
                             PropCount : Integer;
                             Report    : TStringGrid);
var Ind     : integer;
    WStr    : string;
begin
  Report.RowCount := PropCount + Report.FixedRows;
  Report.Cells[0,0] := '';
  Report.Cells[1,0] := ' ';
  Report.Cells[2,0] := ' ';
  //      
  for Ind := 0 to PropCount - 1 do
  begin
      //  
      WStr := GetEnumName(TypeInfo(TTypeKind),
                          integer(PListProp^[Ind].PropType^.Kind));
      //  
      Report.Cells[0, Ind + Report.FixedRows] := Wstr;
      //   
      Report.Cells[1, Ind + Report.FixedRows] := PListProp^[Ind].Name;
      //   
      Report.Cells[2, Ind + Report.FixedRows] := PListProp^[Ind].PropType^.Name;
  end;
end;

//       
procedure EnumClassProrerty(RqClass : TClass; Report : TStringGrid);
var
  ATypeInfo  : PTypeInfo;  //   
  ATypeData  : PTypeData;  //     
  PropCount  : Integer;    //  
  PListProp  : PPropList;  //   

begin
  //        
  ATypeInfo  := PTypeInfo(RqClass.ClassInfo);
  ATypeData  := GetTypeData(ATypeInfo);
  //     
  PropCount  := ATypeData^.PropCount;
  if PropCount > 0 then
  begin
    GetMem(PListProp, PropCount * SizeOf(Pointer));
    //    
    GetPropInfos(ATypeInfo, PListProp);
    //    
    ShowClassProrerty(PListProp,PropCount,Report);
    FreeMem(PListProp, PropCount * SizeOf(Pointer));
  end;
end;


end.
